// Perch Content Script - injects console interceptor into page context

// Chrome <144 compatibility: alias chrome to browser
if (typeof browser === 'undefined') {
  globalThis.browser = chrome;
}

(function() {
  'use strict';

  if (window.__perchContentScriptLoaded__) return;
  window.__perchContentScriptLoaded__ = true;

  // Inject the main-world script
  const script = document.createElement('script');
  script.src = browser.runtime.getURL('injected.js');
  script.onload = () => script.remove();
  (document.head || document.documentElement).appendChild(script);

  // Forward messages from injected script to background
  window.addEventListener('message', (event) => {
    if (event.source !== window) return;
    if (!event.data || !event.data.__perch__) return;

    browser.runtime.sendMessage({
      type: event.data.type,
      level: event.data.level,
      message: event.data.message,
      url: event.data.url,
      timestamp: event.data.timestamp,
      source_file: event.data.source_file,
      line_number: event.data.line_number
    }).catch(() => {});
  });
})();
